set more off
graph drop _all
use lfpr-series-sa.dta , clear
sort year month
gen time=_n
foreach var of varlist lfpr_1624-lfpr_prime_moreed {
replace `var'=`var'*100
gen `var'_6ma=(`var'+`var'[_n-1]+`var'[_n-2]+`var'[_n-3]+`var'[_n-4]+`var'[_n-5])/6
}

# delimit ;
twoway 
	(connected lfpr_1624_6ma time, lwidth(thin) msymbol(none) msize(small) mcolor(maroon) lcolor(maroon) lpattern(solid))
	(connected lfpr_prime_lessed_m_6ma time, lwidth(medium) msymbol(none) msize(small) mcolor(navy) lcolor(navy) lpattern(dash))
	(connected lfpr_prime_moreed_m_6ma time, lwidth(medthick) msymbol(none) msize(small) mcolor(navy) lcolor(navy) lpattern(dot))
	(connected lfpr_prime_lessed_f_6ma time, lwidth(medium) msymbol(none) msize(small) mcolor(orange) lcolor(orange) lpattern(dash))
	(connected lfpr_prime_moreed_f_6ma time, lwidth(medthick) msymbol(none) msize(small) mcolor(orange) lcolor(orange) lpattern(dot))
	(connected lfpr_55p_6ma time, lwidth(thin) msymbol(none) msize(small) mcolor(black) lcolor(black) lpattern(solid)),
	graphregion(  fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) 
	plotregion(fcolor(white) lcolor(black) ifcolor(white) ilcolor(white) margin(medium))
	xlabel(1 "1976" 49 "1980" 109 "1985" 169 "1990" 229 "1995" 289 "2000" 349 "2005" 409 "2010" 457 "2014", labsize(vsmall)) xmlabel(1(12)468, nolab)
	legend(order(1 "16-24" 2 "25-54 males, no college degree" 3 "25-54 males, college degree" 4 "25-54 females, no college degree" 5 "25-54 females, college degree" 6 "55+") size(vsmall) rows(3))
	xtitle("")
	ylabel(20(20)100, labsize(vsmall) glcolor(black) glwidth(vthin))
	ymlabel(20(10)100, nolab glcolor(black) glwidth(vthin) )
	ytitle("Labor force participation rate", size(vsmall) axis(1))
	title("", size(vsmall))
	name(LFPR, replace)
	saving("lfpr-by-group.gph", replace);

twoway 
	(connected lfpr_1624_6ma time, yaxis(1) lwidth(thin) msymbol(none) msize(small) mcolor(maroon) lcolor(maroon) lpattern(solid))
	(connected lfpr_prime_lessed_m_6ma time, yaxis(2) lwidth(medium) msymbol(none) msize(small) mcolor(navy) lcolor(navy) lpattern(dash)),
	graphregion(  fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) 
	plotregion(fcolor(white) lcolor(black) ifcolor(white) ilcolor(white) margin(medium))
	xlabel(1 "1976" 49 "1980" 109 "1985" 169 "1990" 229 "1995" 289 "2000" 349 "2005" 409 "2010" 457 "2014", labsize(vsmall)) xmlabel(1(12)468, nolab)
	legend(order(1 "16-24 (left axis)" 2 "25-54 males, no college degree (right axis)" ) size(vsmall) rows(3))
	xtitle("")
	ylabel(55(5)70, axis(1) labsize(vsmall) glcolor(black) glwidth(vthin))
	ymlabel(55(2.5)70, axis(1) nolab glcolor(black) glwidth(vthin))
	ylabel(80(5)95, axis(2) labsize(vsmall) glcolor(black) glwidth(vthin))
	ymlabel(80(2.5)95, axis(2) nolab glcolor(black) glwidth(vthin))
	ytitle("LFPR, 16-24 yr olds", size(vsmall) axis(1))
	ytitle("LFPR, 25-54 yr old men without college", size(vsmall) axis(2))
	title("", size(vsmall))
	name(LFPR2, replace)
	saving("lfpr-by-group2.gph", replace);

	